#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <linux/types.h> 
#include <gtk/gtk.h>
#include <linux/videodev.h>
#include "gqcam.h"
#include "frontend.h"
#include "greyscale.h"



void create_controls_greyscale(struct Camera *camera) 
{
  GtkWidget *outerbox;
  GtkWidget *innerbox;
  GtkWidget *scalebox;
  GtkWidget *sizedepthbox;
  GtkWidget *frame;
  GtkObject *adjbrightness;
  GtkWidget *scalebrightness;
  GtkObject *adjwhite;
  GtkWidget *scalewhite;
  GtkObject *adjcontrast;
  GtkWidget *scalecontrast;
  GtkWidget *radiobutton;
  GSList *radiogroup;
  GtkWidget *button;

  /* Create new outerbox */
  camera->controltop = gtk_hbox_new (FALSE, 0);

  /* Create scalebox */
  scalebox = gtk_vbox_new (FALSE, 2);
  gtk_widget_set_usize (GTK_WIDGET(scalebox), 240, 150);
  gtk_box_pack_start( GTK_BOX (camera->controltop), scalebox, 1, 1, 0);
  gtk_widget_show (scalebox);

  /* Create Brightness Scale */
  frame = gtk_frame_new("Brightness");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  adjbrightness = gtk_adjustment_new(camera->vid_pic.brightness/256, 0, 255, 1, 10, 1);
  scalebrightness = gtk_hscale_new(GTK_ADJUSTMENT(adjbrightness));

  gtk_signal_connect (GTK_OBJECT (adjbrightness), "value_changed",
	 	      GTK_SIGNAL_FUNC (setbrightness), camera);

  gtk_scale_set_digits(GTK_SCALE(scalebrightness), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalebrightness);
  gtk_widget_show (scalebrightness);
  
  /* Create White Balance Scale */
  frame = gtk_frame_new("White Balance");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);
  adjwhite = gtk_adjustment_new(camera->vid_pic.whiteness/256, 0, 255, 1, 10, 1);
  scalewhite = gtk_hscale_new(GTK_ADJUSTMENT(adjwhite));

  gtk_signal_connect (GTK_OBJECT (adjwhite), "value_changed",
	 	      GTK_SIGNAL_FUNC (setwhite), camera);

  gtk_scale_set_digits(GTK_SCALE(scalewhite), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalewhite);
  gtk_widget_show (scalewhite);

  /* Create Contrast Scale */
  frame = gtk_frame_new("Contrast");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  adjcontrast = gtk_adjustment_new( camera->vid_pic.contrast/256, 0, 255, 1, 10, 1);
  scalecontrast = gtk_hscale_new(GTK_ADJUSTMENT(adjcontrast));

  gtk_signal_connect (GTK_OBJECT (adjcontrast), "value_changed",
		      GTK_SIGNAL_FUNC (setcontrast), camera);

  gtk_scale_set_digits(GTK_SCALE(scalecontrast), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalecontrast);
  gtk_widget_show (scalecontrast);

  /* Create sizedepthbox */
  sizedepthbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start( GTK_BOX (camera->controltop), sizedepthbox, 1, 1, 0);
  gtk_widget_show (sizedepthbox);

  /* This is the size... */
  frame = gtk_frame_new("Size");
  gtk_box_pack_start( GTK_BOX (sizedepthbox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame), innerbox);
  gtk_widget_show (innerbox);

  radiobutton = gtk_radio_button_new_with_label (NULL, "Full");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == camera->vid_caps.maxwidth)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setsizefull), camera);

  gtk_widget_show (radiobutton);
  
  radiogroup = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton));
  radiobutton = gtk_radio_button_new_with_label(radiogroup, "Half");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/2)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setsizehalf), camera);
  
  gtk_widget_show (radiobutton);

  radiobutton = gtk_radio_button_new_with_label( gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton)), "Quarter");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/4)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setsizequarter), camera);

  gtk_widget_show (radiobutton);

  /* ...and this is the depth */
  frame = gtk_frame_new("Depth");
  gtk_box_pack_start( GTK_BOX (sizedepthbox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame), innerbox);
  gtk_widget_show (innerbox);

  radiobutton = gtk_radio_button_new_with_label (NULL, "4 bpp");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_pic.depth == 4)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setdepth4), camera);

  gtk_widget_show (radiobutton);

  radiogroup = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton));
  radiobutton = gtk_radio_button_new_with_label(radiogroup, "6 bpp");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_pic.depth == 6)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setdepth6), camera);

  gtk_widget_show (radiobutton);

  gtk_widget_show (camera->controltop);

}
