struct Page_Ppm
{
  GtkWidget *frame_ppm;
  GtkWidget *label_ppm;
  GtkWidget *radio_raw_ppm;
  GtkWidget *radio_ascii_ppm;
  GtkWidget *vbox_ppm;
  GSList *group_ppm;
};

struct Page_Jpeg 
{
  GtkWidget *frame_jpeg;
  GtkWidget *vbox_jpeg;
  GtkWidget *table_jpeg;
  GtkWidget *quality_jpeg;
  GtkWidget *smooth_jpeg;
  GtkWidget *label_jpeg;
  GtkWidget *optimize_jpeg;
  GtkObject *quality_adj_jpeg;
  GtkObject *smooth_adj_jpeg;
};

struct Page_Png
{
  GtkWidget *frame_png;
  GtkWidget *vbox_png;
  GtkWidget *hbox_png;
  GtkWidget *interlace_png;
  GtkWidget *label_png;
  GtkWidget *compression_png;
  GtkObject *compression_adj_png;  
};

struct Page_Gif
{
  GtkWidget *frame_gif;
  GtkWidget *vbox_gif;
  GtkWidget *label_gif;
  GtkWidget *interlace_gif;
  GtkWidget *comment_gif;
  GtkWidget *comment_text_gif;
  GtkWidget *scrollbox_gif;
};

struct Camera
{
  int dev;
  int greyscale;
  int draw;
  int frozen;
  int update_camera;
  int capture;
  int saving;
  int savetype;
  int docked;
  int dump;
  struct video_capability vid_caps;
  struct video_window vid_win;
  struct video_picture vid_pic;
  struct video_clip vid_clips[32];
  unsigned char *pic;
  unsigned char *picbuff;
  char devname[256];
  GtkWidget *drawing_area;
  GtkWidget *controlcontainer, *controltop, *controlwindow;
  GtkWidget *statusbar;
  GtkWidget *currentsavepage;
  pthread_mutex_t iscam_mutex, pref_mutex, freeze_mutex;
  GdkPixmap *pixmap;
  int fps_avg;
  int fps_current;
  struct Page_Ppm page_ppm;
  struct Page_Jpeg page_jpeg;
  struct Page_Gif page_gif;
  struct Page_Png page_png;
};



void display(struct Camera*);
void delete_event(GtkWidget*, GdkEvent*, gpointer);
void open_cam(struct Camera*);
void close_cam(struct Camera*, int force);
void print_cam_info(struct Camera*);
void get_cam_info(struct Camera*);
