#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <linux/types.h> 
#include <gtk/gtk.h>
#include <linux/videodev.h>
#include "gqcam.h"
#include "frontend.h"
#include "color.h"



void create_controls_color(struct Camera *camera)
{
  GtkWidget *outerbox;
  GtkWidget *innerbox;
  GtkWidget *scalebox;
  GtkWidget *sizedepthbox;
  GtkWidget *frame;
  GtkObject *adjbrightness;
  GtkWidget *scalebrightness;
  GtkObject *adjwhite;
  GtkWidget *scalewhite;
  GtkObject *adjcontrast;
  GtkWidget *scalecontrast;
  GtkObject *adjhue;
  GtkWidget *scalehue;
  GtkObject *adjcolor;
  GtkWidget *scalecolor;
  GtkWidget *radiobutton;
  GSList *radiogroup;
  GtkWidget *button;
  int ib=130, ic=30, iw=150, i, count=32;
  gint context_id;

  /* Create new outerbox */
  camera->controltop = gtk_hbox_new (FALSE, 0);

  /* Create scalebox */
  scalebox = gtk_vbox_new (FALSE, 2);
  gtk_widget_set_usize (GTK_WIDGET(scalebox), 240, 250);
  gtk_box_pack_start( GTK_BOX (camera->controltop), scalebox, 1, 1, 0);
  gtk_widget_show (scalebox);

  /* Create Brightness Scale */
  frame = gtk_frame_new("Brightness");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  adjbrightness = gtk_adjustment_new(camera->vid_pic.brightness/256, 0, 255, 1, 10, 1);
  scalebrightness = gtk_hscale_new(GTK_ADJUSTMENT(adjbrightness));
  gtk_range_set_update_policy( GTK_RANGE(scalebrightness), GTK_UPDATE_DELAYED ); 

  gtk_signal_connect (GTK_OBJECT (adjbrightness), "value_changed",
		      GTK_SIGNAL_FUNC (setbrightness), camera);

  gtk_scale_set_digits(GTK_SCALE(scalebrightness), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalebrightness);
  gtk_widget_show (scalebrightness);
  
  /* Create White Balance Scale */
  frame = gtk_frame_new("White Balance");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);
  adjwhite = gtk_adjustment_new(camera->vid_pic.whiteness/256, 0, 255, 1, 10, 1);
  scalewhite = gtk_hscale_new(GTK_ADJUSTMENT(adjwhite));
  gtk_range_set_update_policy( GTK_RANGE(scalewhite), GTK_UPDATE_DELAYED ); 

  gtk_signal_connect (GTK_OBJECT (adjwhite), "value_changed",
		      GTK_SIGNAL_FUNC (setwhite), camera);

  gtk_scale_set_digits(GTK_SCALE(scalewhite), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalewhite);
  gtk_widget_show (scalewhite);

  /* Create Contrast Scale */
  frame = gtk_frame_new("Contrast");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  adjcontrast = gtk_adjustment_new(camera->vid_pic.contrast/256, 0, 255, 1, 10, 1);
  scalecontrast = gtk_hscale_new(GTK_ADJUSTMENT(adjcontrast));
  gtk_range_set_update_policy( GTK_RANGE(scalecontrast), GTK_UPDATE_DELAYED ); 


  gtk_signal_connect (GTK_OBJECT (adjcontrast), "value_changed",
		      GTK_SIGNAL_FUNC (setcontrast), camera);

  gtk_scale_set_digits(GTK_SCALE(scalecontrast), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalecontrast);
  gtk_widget_show (scalecontrast);

  /* Create Hue Scale */
  frame = gtk_frame_new("Hue");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  adjhue = gtk_adjustment_new(camera->vid_pic.hue/256, 0, 255, 1, 10, 1);
  scalehue = gtk_hscale_new(GTK_ADJUSTMENT(adjhue));
  gtk_range_set_update_policy( GTK_RANGE(scalehue), GTK_UPDATE_DELAYED ); 

  gtk_signal_connect (GTK_OBJECT (adjhue), "value_changed",
		      GTK_SIGNAL_FUNC (sethue), camera);

  gtk_scale_set_digits(GTK_SCALE(scalehue), 0);
  gtk_container_add (GTK_CONTAINER (frame), scalehue);
  gtk_widget_show (scalehue);

  /* Create Color Scale */
  frame = gtk_frame_new("Color");
  gtk_box_pack_start( GTK_BOX (scalebox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  adjcolor = gtk_adjustment_new(camera->vid_pic.colour/256, 0, 255, 1, 10, 1);
  scalecolor = gtk_hscale_new(GTK_ADJUSTMENT(adjcolor));

  gtk_signal_connect (GTK_OBJECT (adjcolor), "value_changed",
		      GTK_SIGNAL_FUNC (setcolor), camera);

  gtk_scale_set_digits(GTK_SCALE(scalecolor), 0);
  gtk_range_set_update_policy( GTK_RANGE(scalecolor), GTK_UPDATE_DELAYED ); 

  gtk_container_add (GTK_CONTAINER (frame), scalecolor);
  gtk_widget_show (scalecolor);

  /* Create sizedepthbox */
  sizedepthbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start( GTK_BOX (camera->controltop), sizedepthbox, 1, 1, 0);
  gtk_widget_show (sizedepthbox);

  /* This is the size... */
  frame = gtk_frame_new("Size");
  gtk_box_pack_start( GTK_BOX (sizedepthbox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame), innerbox);
  gtk_widget_show (innerbox);

  radiobutton = gtk_radio_button_new_with_label (NULL, "Full");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == camera->vid_caps.maxwidth)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setsizefull), camera);

  gtk_widget_show (radiobutton);
  
  radiogroup = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton));
  radiobutton = gtk_radio_button_new_with_label(radiogroup, "Half");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/2)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);

  gtk_signal_connect (GTK_OBJECT (radiobutton), "pressed",
		      (GtkSignalFunc) setsizehalf, camera);

  //  gtk_signal_connect(GTK_OBJECT (radiobutton), "clicked", (GtkSignalFunc)setsizehalf, camera);

  gtk_widget_show (radiobutton);

  radiobutton = gtk_radio_button_new_with_label( gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton)), "Quarter");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/4)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (radiobutton), "pressed", (GtkSignalFunc)setsizequarter, camera);

  gtk_widget_show (radiobutton);

  /* ...and this is the depth */
/*
  frame = gtk_frame_new("Speed");
  gtk_box_pack_start( GTK_BOX (sizedepthbox), frame, 1, 1, 0);
  gtk_widget_show (frame);

  innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame), innerbox);
  gtk_widget_show (innerbox);



  camera->statusbar = gtk_statusbar_new();
  gtk_box_pack_start(GTK_BOX(innerbox), camera->statusbar, TRUE, TRUE, 0);
  gtk_widget_show( camera->statusbar );
  context_id = gtk_statusbar_get_context_id( GTK_STATUSBAR(camera->statusbar), "Statusbar example" );
  gtk_statusbar_push( GTK_STATUSBAR( camera->statusbar ), context_id, "WHEEEE" );


  radiobutton = gtk_radio_button_new_with_label (NULL, "4 bpp");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_pic.depth == 4)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect_object (GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setdepth4), NULL);

  gtk_widget_show (radiobutton);

  radiogroup = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton));
  radiobutton = gtk_radio_button_new_with_label(radiogroup, "6 bpp");
  gtk_box_pack_start (GTK_BOX (innerbox), radiobutton, TRUE, TRUE, 0);

  if (camera->vid_pic.depth == 6)
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_signal_connect_object (GTK_OBJECT (radiobutton), "pressed", GTK_SIGNAL_FUNC(setdepth6), NULL);

  gtk_widget_show (radiobutton);
*/
  gtk_widget_show (camera->controltop);
  
}
