/** gaddr 1.0 - simple and small address book application using GTK+
    Copyright (C) 1999 Cory Lueninghoener (cluenin1@bigred.unl.edu)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */


#include <gtk/gtk.h>
#include "db.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <gdk/gdk.h>
#include "cardfile.xpm"

/*
  Initialize the pile o' widgets
*/
GtkWidget *window;
GtkWidget *iconwindow;
GtkWidget *viewbutton;
GtkWidget *newbutton;
GtkWidget *editbutton;
GtkWidget *deletebutton;
GtkWidget *quitbutton;
GtkWidget *table;
GtkWidget *listbox;
GtkWidget *hsep1;
GtkWidget *hsep2;
GtkWidget *vsep1;
GtkWidget *viewwindow;
GtkWidget *textbox;
GtkWidget *closebutton;
GtkWidget *newdialogwindow;
GtkWidget *newdialoginput;
GtkWidget *newdialoglabel;
GtkWidget *newdialogbuttonok;
GtkWidget *newdialogbuttoncancel;
GtkWidget *listscroll;
GtkWidget *menubar;
GtkWidget *filewindow;
GtkWidget *confirmwindow;
GtkWidget *confirmok;
GtkWidget *confirmcancel;
GtkWidget *confirmlabel;
GtkWidget *aboutwindow;
GtkWidget *aboutlabel;
GtkWidget *aboutbutton;

GdkPixmap* icon;

GtkMenuFactory *factory;
GtkMenuFactory *subfactory;

struct corydb *addressdb;
char *entryname;
char book_file[512];

int selected_row, selected_column;
int yes=1;
int no=0;
int edited=0;

void quit (GtkWidget*, GdkEvent*, gpointer);
void new();
void save_as();
void delete();
void view(GtkWidget*, gpointer);
void write_out();
void newfile();
void openfile();
void delete_widget(GtkWidget*, gpointer);
void about();

/*
  Callbacks for the view and edit buttons
*/
void menuview(GtkWidget *widget)
{
  view(widget, (gpointer) no);
}
void menuedit(GtkWidget *widget)
{
  view(widget, (gpointer) yes);
}

/*
  Set up the menu
*/
static GtkItemFactoryEntry menu_items[] = {
  {"/_File",         NULL,         NULL,        0, "<Branch>"},
  {"/File/_New",     NULL,         newfile,     0, NULL},
  {"/File/_Open",    "<control>O", openfile,    0, NULL},
  {"/File/_Save",    "<control>S", write_out,   0, NULL},
  {"/File/Save _As", NULL,         save_as,     0, NULL},
  {"/File/sep1",     NULL,         NULL,        0, "<Separator>"},
  {"/File/Quit",     "<control>Q", quit,        0, NULL},

  {"/_Card",         NULL,         NULL,        0, "<Branch>"},
  {"/Card/_New",     "<control>N", new,         0, NULL},
  {"/Card/View",     NULL,         menuview,    0, NULL},
  {"/Card/Delete",   NULL,         delete,      0, NULL},
  {"/Card/Edit",     NULL,         menuedit,    0, NULL},

  {"/_Help",         NULL,         NULL,        0, "<LastBranch>"},
  {"/_Help/About",   NULL,         about,       0, NULL},
};

/*
  And create the main menu
*/
void get_main_menu(GtkWidget *window, GtkWidget ** menubar)
{
  int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  accel_group = gtk_accel_group_new();
  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", 
				      accel_group);
  gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));

  if (menubar)
    *menubar = gtk_item_factory_get_widget(item_factory, "<main>");
}

/*
  Display the About box, so everybody can see my name.
*/
void about()
{
  aboutwindow = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_container_border_width(GTK_CONTAINER(aboutwindow), 5);
  gtk_window_position (GTK_WINDOW(aboutwindow), GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (aboutwindow), "About Gaddr 1.0.2");  
  
  table = gtk_table_new(2, 3, FALSE);
  gtk_container_add(GTK_CONTAINER(aboutwindow), table);
  
  aboutlabel = gtk_label_new("Gaddr is a GTK Address Book.\nGaddr (C)1999 Cory Lueninghoener\nCoryDB (C)1999 Matt Fisher\nDistributed under the GNU Public License\nhttp://cse.unl.edu/~cluening/gaddr");
  gtk_table_attach_defaults(GTK_TABLE(table), aboutlabel, 0, 3, 0, 1);
  
  aboutbutton = gtk_button_new_with_label("Close");
  gtk_table_attach_defaults(GTK_TABLE(table), aboutbutton, 1, 2, 1, 2);
  
  gtk_signal_connect(GTK_OBJECT(aboutbutton), "clicked",
		     GTK_SIGNAL_FUNC(delete_widget),
		     aboutwindow);
  
  gtk_widget_show(aboutbutton);
  gtk_widget_show(aboutlabel);
  gtk_widget_show(table);
  gtk_widget_show(aboutwindow);  
}

/*
  Read list of records from the selected file
*/
void read_in()
{
  FILE *infile;
  char intemp[500] = "";
  char instore[500] = "";
  char inname[30] = "";
  gchar *entry[1][1];
  
  if ((infile = fopen(book_file, "r")) !=NULL)
    {
      while (fgets(intemp, 500, infile)!=NULL)
	{
	  intemp[(strlen(intemp)-1)]=0;
	  strcpy(inname, intemp);
	  while (strstr(intemp, "---endentry---") == NULL)
	    {
	      fgets(intemp, 500, infile);
	      if (strstr(intemp, "---endentry---") == NULL)
		strcat(instore, intemp);
	    }
	  instore[strlen(instore)-1]=0;
	  add_list(addressdb, inname, instore);
	  entry[0][0] = inname;
	  gtk_clist_append((GtkCList*) listbox, *entry);

	  strcpy(intemp, "");
	  strcpy(instore, "");
	  strcpy(inname, "");
	}
      fclose(infile);
    }
}

/*
  Write it all back out to the selected file
*/
void write_out()
{
  int counter, compare;
  char *namechar;
  FILE *outfile;
  outfile=fopen(book_file, "w");

  compare = 1;
  counter=0;
  edited = 0;
  while ((gtk_clist_get_text(GTK_CLIST(listbox), counter, 0, &namechar)!=0)&&(compare > 0))
    {
      fprintf(outfile, "%s\n", namechar);
      fprintf(outfile, "%s\n", retr_list(addressdb, namechar));
      fprintf(outfile, "---endentry---\n");
      counter++;
    }
  fclose(outfile);
}

/*
  Called when the view/edit window is closed
*/
void closewindow(GtkWidget *widget, gchar *name)
{
  gtk_clist_set_selection_mode(GTK_CLIST(listbox), GTK_SELECTION_SINGLE);
  edit_list(addressdb, name, gtk_editable_get_chars(GTK_EDITABLE(textbox), 0, -1)); 
  gtk_widget_destroy(widget->parent->parent);
  viewwindow = NULL;
}

/*
  Quits the program for good
*/
gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  return (TRUE);
}

/*
  Called when something is selected from the list
*/
void set_selected(GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer data)
{
  selected_row = row;
  selected_column = column;
  if (event && (event->type == GDK_2BUTTON_PRESS))
    {
      view(widget, (gpointer) no);
    }

  return;
}

/*
  Allows you to view or edit the card
*/
void view(GtkWidget *widget, gpointer   data)
{
  gchar *title;
  
  if (gtk_clist_get_text(GTK_CLIST(listbox), selected_row, selected_column, &title) == 0)
     return;
  if (viewwindow != NULL)
    {
      return;
    }
  if (data == (gpointer) 1)
    edited = 1;

  gtk_clist_set_selection_mode(GTK_CLIST(listbox), GTK_SELECTION_EXTENDED);

  viewwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  
  gtk_signal_connect (GTK_OBJECT (viewwindow), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);

  gtk_window_set_title(GTK_WINDOW(viewwindow), title);

  textbox = gtk_text_new(NULL, NULL);
  table = gtk_table_new(3, 1, FALSE);
  closebutton = gtk_button_new_with_label("Close");

  gtk_signal_connect (GTK_OBJECT (closebutton), "clicked",
		      GTK_SIGNAL_FUNC (closewindow), title);

  gtk_text_set_editable(GTK_TEXT(textbox), TRUE);

  hsep1 = gtk_hseparator_new();
  gtk_table_attach_defaults(GTK_TABLE(table), hsep1, 0, 1, 1, 2);

  gtk_container_border_width (GTK_CONTAINER(viewwindow), 2);
  gtk_widget_set_usize(textbox, 300, 180);  

  gtk_container_add (GTK_CONTAINER (viewwindow), table);

  gtk_table_attach_defaults(GTK_TABLE(table), closebutton, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE(table), textbox, 0, 1, 0, 1);

  gtk_widget_show(hsep1);
  gtk_widget_show(closebutton);
  gtk_widget_show(textbox);

  gtk_widget_realize (textbox);
  gtk_text_insert(GTK_TEXT(textbox), NULL, NULL, NULL, retr_list(addressdb, title), -1 );

  if (data == 0)
    {
      gtk_text_set_editable(GTK_TEXT(textbox), FALSE);
    }

  gtk_widget_show(table);
  gtk_widget_show(viewwindow);
}

/*
  General purpose "Get rid of a widget" function
*/
void delete_widget(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(data);
}

/*
  If "Ok" is selected from the "New" dialog
*/
void newok(GtkWidget *widget)
{
  int counter, compare;
  gchar *namechar, *entryname[1][1];

  entryname[0][0] = gtk_editable_get_chars(GTK_EDITABLE(newdialoginput), 0, -1);
  counter=0;
  compare=1;
  
  while ((gtk_clist_get_text(GTK_CLIST(listbox), counter, 0, &namechar)!=0)&&(compare > 0))
    {
      compare = strcmp(entryname[0][0], namechar);
      if (compare > 0)
	counter++;
    }
  gtk_clist_insert (GTK_CLIST(listbox), counter, *entryname);
  add_list(addressdb, entryname[0][0], "");
  gtk_widget_destroy(newdialogwindow);
  gtk_clist_select_row(GTK_CLIST(listbox), counter, 0);
  view(widget, (gpointer) yes);
}

/*
  Wanna create a new card?  This does it...
*/
void new()
{
  newdialogwindow = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_container_border_width(GTK_CONTAINER(newdialogwindow), 5);
  gtk_window_position (GTK_WINDOW(newdialogwindow), GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (newdialogwindow), "Create New Card");

  table = gtk_table_new(4, 2, TRUE);
  gtk_container_add(GTK_CONTAINER(newdialogwindow), table);
  
  newdialoglabel = gtk_label_new("Enter Name:");
  gtk_table_attach_defaults(GTK_TABLE(table), newdialoglabel, 0, 2, 0, 1);

  newdialoginput = gtk_entry_new_with_max_length(39);
  gtk_table_attach_defaults(GTK_TABLE(table), newdialoginput, 0, 2, 1, 2);

  hsep1 = gtk_hseparator_new();
  gtk_table_attach_defaults(GTK_TABLE(table), hsep1, 0, 2, 2, 3);

  newdialogbuttonok = gtk_button_new_with_label("Ok");
  gtk_table_attach_defaults(GTK_TABLE(table), newdialogbuttonok, 0, 1, 3, 4);
  
  gtk_signal_connect(GTK_OBJECT(newdialogbuttonok), "clicked",
		     GTK_SIGNAL_FUNC(newok),
		     NULL);

  newdialogbuttoncancel = gtk_button_new_with_label("Cancel");
  gtk_table_attach_defaults(GTK_TABLE(table), newdialogbuttoncancel, 1, 2, 3, 4);

  gtk_signal_connect(GTK_OBJECT(newdialogbuttoncancel), "clicked",
		     GTK_SIGNAL_FUNC(delete_widget),
		     newdialogwindow);

  gtk_widget_show(newdialogbuttonok);
  gtk_widget_show(newdialogbuttoncancel);
  gtk_widget_show(hsep1);
  gtk_widget_show(newdialoginput);
  gtk_widget_show(newdialoglabel);
  gtk_widget_show(table);
  gtk_widget_show(newdialogwindow);
}


/* 
   This callback quits the program 
*/
void quit (GtkWidget *widget, GdkEvent *event, gpointer data)
{
  if (edited == 1)
    {
      confirmwindow = gtk_window_new(GTK_WINDOW_DIALOG);
      gtk_container_border_width(GTK_CONTAINER(confirmwindow), 5);
      gtk_window_position (GTK_WINDOW(confirmwindow), GTK_WIN_POS_MOUSE);
      gtk_window_set_title (GTK_WINDOW (confirmwindow), "Really quit?");
      
      
      table = gtk_table_new(3, 2, TRUE);
      gtk_container_add(GTK_CONTAINER(confirmwindow), table);
      
      confirmlabel = gtk_label_new("File is unsaved.  Are you\nsure you want to quit?");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmlabel, 0, 2, 0, 2);
      
      confirmok = gtk_button_new_with_label("Ok");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmok, 0, 1, 2, 3);
      
      gtk_signal_connect(GTK_OBJECT(confirmok), "clicked",
      			 GTK_SIGNAL_FUNC(gtk_main_quit),
			 NULL);
      
      confirmcancel = gtk_button_new_with_label("Cancel");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmcancel, 1, 2, 2, 3);
      
      gtk_signal_connect(GTK_OBJECT(confirmcancel), "clicked",
			 GTK_SIGNAL_FUNC(delete_widget),
			 confirmwindow);
      
      gtk_widget_show(confirmok);
      gtk_widget_show(confirmcancel);
      gtk_widget_show(confirmlabel);
      gtk_widget_show(table);
      gtk_widget_show(confirmwindow);
      
    }
 
  else
    gtk_main_quit ();
}

/*
  Here is how we delete a card
*/
void delete()
{
  gchar *name;
  
  edited = 1;
  gtk_clist_get_text(GTK_CLIST(listbox), selected_row, selected_column, &name);

  del_list(addressdb, name);
  gtk_clist_remove(GTK_CLIST(listbox), selected_row );
}

/*
  Callback connected to the "Save As" dialog window
*/
void save_as_ok(GtkWidget *w, GtkFileSelection *fs)
{
  strcpy(book_file, gtk_file_selection_get_filename(GTK_FILE_SELECTION (fs)));
  write_out();
  edited = 0;
  gtk_widget_destroy(filewindow);
}

/*
  Callback connected to the "Save As" menu choice
*/
void save_as()
{
  /* Create a new file selection widget */
  filewindow = gtk_file_selection_new ("Save As");
  
  gtk_signal_connect (GTK_OBJECT (filewindow), "destroy",
		      (GtkSignalFunc) delete_event, &filewindow);
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filewindow)->ok_button),
		      "clicked", (GtkSignalFunc) save_as_ok, filewindow );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filewindow)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filewindow));
  
  /* Lets set the filename, as if this were a save dialog, and we are giving
     a default filename */
  gtk_file_selection_set_filename (GTK_FILE_SELECTION(filewindow), 
				   book_file);
  
  gtk_widget_show(filewindow);
}

/*
  Connected to the "Open" file selection box's Ok button
*/
void openfileokok(GtkWidget *w, GtkFileSelection *fs)
{
  wipe_list(addressdb);
  addressdb=init_list();
  gtk_clist_clear(GTK_CLIST(listbox));
  edited = 0;
  
  strcpy(book_file, gtk_file_selection_get_filename(GTK_FILE_SELECTION (fs)));
  read_in();
  gtk_widget_destroy(filewindow);
}

/*
  If Brings up the file selection dialog
*/
void openfileok()
{
  if (confirmwindow != NULL)
    gtk_widget_destroy(confirmwindow);
  
  /* Create a new file selection widget */
  filewindow = gtk_file_selection_new ("Open File");
  
  gtk_signal_connect (GTK_OBJECT (filewindow), "destroy",
		      (GtkSignalFunc) delete_event, &filewindow);
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filewindow)->ok_button),
		      "clicked", (GtkSignalFunc) openfileokok, filewindow );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filewindow)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filewindow));
  
  /* Lets set the filename, as if this were a save dialog, and we are giving
     a default filename */
  gtk_file_selection_set_filename (GTK_FILE_SELECTION(filewindow), 
				   book_file);
  
  gtk_widget_show(filewindow);
}

/*
  Callback connected to the "Open" menu item; either calls the file selection dialog or the confirmation window
*/
void openfile()
{
  if (edited == 1)
    {
      confirmwindow = gtk_window_new(GTK_WINDOW_DIALOG);
      gtk_container_border_width(GTK_CONTAINER(confirmwindow), 5);
      gtk_window_position (GTK_WINDOW(confirmwindow), GTK_WIN_POS_MOUSE);
      gtk_window_set_title (GTK_WINDOW (confirmwindow), "File Unsaved!");
      
      
      table = gtk_table_new(3, 2, TRUE);
      gtk_container_add(GTK_CONTAINER(confirmwindow), table);
      
      confirmlabel = gtk_label_new("File is unsaved.  Are you\nsure you want to open a new one?");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmlabel, 0, 2, 0, 2);
      
      confirmok = gtk_button_new_with_label("Ok");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmok, 0, 1, 2, 3);
      
      gtk_signal_connect(GTK_OBJECT(confirmok), "clicked",
      			 GTK_SIGNAL_FUNC(openfileok),
			 NULL);
      
      confirmcancel = gtk_button_new_with_label("Cancel");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmcancel, 1, 2, 2, 3);
      
      gtk_signal_connect(GTK_OBJECT(confirmcancel), "clicked",
			 GTK_SIGNAL_FUNC(delete_widget),
			 confirmwindow);
      
      gtk_widget_show(confirmok);
      gtk_widget_show(confirmcancel);
      gtk_widget_show(confirmlabel);
      gtk_widget_show(table);
      gtk_widget_show(confirmwindow);
    }
  else
    openfileok();
}

/*
  If it is Ok to create a new file, this is called
*/
void newfileok()
{
  strcpy(book_file, "Untitled.gaddr");
  wipe_list(addressdb);
  addressdb=init_list();
  edited = 0;
  if (confirmwindow != NULL)
    {
      gtk_widget_destroy(GTK_WIDGET(confirmwindow));
      confirmwindow = NULL;
    }
  gtk_clist_clear(GTK_CLIST(listbox));
}

/*
  Brings up the confirmation to create a new file if needed
*/
void newfile()
{
  if (edited == 1)
    {
      confirmwindow = gtk_window_new(GTK_WINDOW_DIALOG);
      gtk_container_border_width(GTK_CONTAINER(confirmwindow), 5);
      gtk_window_position (GTK_WINDOW(confirmwindow), GTK_WIN_POS_MOUSE);
      gtk_window_set_title (GTK_WINDOW (confirmwindow), "File Unsaved!");
      
      
      table = gtk_table_new(3, 2, TRUE);
      gtk_container_add(GTK_CONTAINER(confirmwindow), table);
      
      confirmlabel = gtk_label_new("File is unsaved.  Are you\nsure you want to create a new one?");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmlabel, 0, 2, 0, 2);
      
      confirmok = gtk_button_new_with_label("Ok");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmok, 0, 1, 2, 3);
      
      gtk_signal_connect(GTK_OBJECT(confirmok), "clicked",
      			 GTK_SIGNAL_FUNC(newfileok),
			 NULL);
      
      confirmcancel = gtk_button_new_with_label("Cancel");
      gtk_table_attach_defaults(GTK_TABLE(table), confirmcancel, 1, 2, 2, 3);
      
      gtk_signal_connect(GTK_OBJECT(confirmcancel), "clicked",
			 GTK_SIGNAL_FUNC(delete_widget),
			 confirmwindow);
      
      gtk_widget_show(confirmok);
      gtk_widget_show(confirmcancel);
      gtk_widget_show(confirmlabel);
      gtk_widget_show(table);
      gtk_widget_show(confirmwindow);
    }
  else
    newfileok();
}

/*
  The main function, of course
*/
int main (int argc, char *argv[])
{
  gtk_init (&argc, &argv);
  addressdb=init_list();

  //strcpy(book_file, "gaddrbook");

  sprintf(book_file, "%s/.gaddrbook", getenv("HOME"));

  /* create a new window */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  iconwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  
  /* set the window title */
  gtk_window_set_title (GTK_WINDOW (window), "Gaddr");

  //  icon=gdk_pixmap_create_from_xpm(window->window, NULL, NULL, "cardfile.xpm");
  //  gdk_window_set_icon(window->window, NULL, icon, NULL);
  
  /* set a handler for delete_event that immediately
   * exits GTK. */
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (quit), NULL);
  
  /* sets the border width of the window. */
  gtk_container_border_width (GTK_CONTAINER(window), 0);
  
  /* create a 2x2 table */
  table = gtk_table_new (8, 3, FALSE);
  
  /* put the table in the main window */
  gtk_container_add (GTK_CONTAINER (window), table);
  
  //------------------------------------------------------------

  get_main_menu(window, &menubar);
  gtk_table_attach_defaults(GTK_TABLE(table), menubar, 0, 3, 0, 1);
  gtk_widget_show(menubar);
  
  //--------------------------------------------------------------


  /*_____List Box_____*/

  listscroll = gtk_scrolled_window_new(NULL, NULL);
  listbox = gtk_clist_new(1);
  gtk_table_attach_defaults (GTK_TABLE(table), listscroll, 2, 3, 1, 8);
  gtk_container_add (GTK_CONTAINER (listscroll), listbox);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (listscroll),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(listscroll, 260, 200);

  gtk_signal_connect(GTK_OBJECT(listbox), "select_row",
		     GTK_SIGNAL_FUNC(set_selected),
		     NULL);
  gtk_clist_set_selection_mode(GTK_CLIST(listbox), GTK_SELECTION_SINGLE);

  /*_____Vertical Seperator_____*/

  vsep1 = gtk_vseparator_new();
  gtk_table_attach_defaults(GTK_TABLE(table), vsep1, 1, 2, 1, 8);

  /*_____View Button____ */

  viewbutton = gtk_button_new_with_label ("View");
  gtk_signal_connect (GTK_OBJECT (viewbutton), "clicked",
		      GTK_SIGNAL_FUNC (view), (gpointer) no);
  gtk_table_attach_defaults (GTK_TABLE(table), viewbutton, 0, 1, 1, 2);
  gtk_widget_show (viewbutton);
  
  /*_____Seperator 1_____*/

  hsep1 = gtk_hseparator_new();
  gtk_table_attach_defaults(GTK_TABLE(table), hsep1, 0, 1, 2, 3);


  /*_____New Button______*/
  
  newbutton = gtk_button_new_with_label ("New");
  gtk_signal_connect (GTK_OBJECT (newbutton), "clicked",
		      GTK_SIGNAL_FUNC (new), (gpointer) "new");
  gtk_table_attach_defaults (GTK_TABLE(table), newbutton, 0, 1, 3, 4);
  gtk_widget_show (newbutton);

  /*_____Edit Button_____*/

  editbutton = gtk_button_new_with_label ("Edit");
  gtk_signal_connect (GTK_OBJECT (editbutton), "clicked",
		      GTK_SIGNAL_FUNC (view), (gpointer) yes);
  gtk_table_attach_defaults (GTK_TABLE(table), editbutton, 0, 1, 4, 5);
  gtk_widget_show (editbutton);

  /*_____Delete Button_____*/

  deletebutton = gtk_button_new_with_label ("Delete");
  gtk_signal_connect (GTK_OBJECT (deletebutton), "clicked",
		      GTK_SIGNAL_FUNC (delete), (gpointer) "delete");
  gtk_table_attach_defaults (GTK_TABLE(table), deletebutton, 0, 1, 5, 6);
  gtk_widget_show (deletebutton);

  /*_____Seperator 2_____*/

  hsep2 = gtk_hseparator_new();
  gtk_table_attach_defaults(GTK_TABLE(table), hsep2, 0, 1, 6, 7);
  
  /*_____Quit Button_____*/

  quitbutton = gtk_button_new_with_label ("Quit");
  gtk_signal_connect (GTK_OBJECT (quitbutton), "clicked",
		      GTK_SIGNAL_FUNC (quit), NULL);
  gtk_table_attach_defaults (GTK_TABLE(table), quitbutton, 0, 1, 7, 8);

  
  gtk_widget_set_usize(viewbutton, 55, 35);
  gtk_widget_set_usize(newbutton, 55, 35);
  gtk_widget_set_usize(editbutton, 55, 35);
  gtk_widget_set_usize(deletebutton, 55, 35);
  gtk_widget_set_usize(quitbutton, 55, 35);
  
  gtk_widget_show(listbox);
  gtk_widget_show(listscroll);
  gtk_widget_show(viewbutton);
  gtk_widget_show(newbutton);
  gtk_widget_show(editbutton);
  gtk_widget_show(deletebutton);
  gtk_widget_show(quitbutton);
  gtk_widget_show(hsep1);
  gtk_widget_show(hsep2);
  gtk_widget_show(vsep1);

  gtk_widget_show (table);
  gtk_widget_show (window);
  
  icon=gdk_pixmap_create_from_xpm_d(window->window, NULL, NULL, cardfile_xpm);

  gdk_window_set_icon(window->window, NULL, icon, NULL);

  if (argv[1] != NULL)
    strcpy(book_file, argv[1]);

  read_in();
  
  gtk_main ();
  
  return 0;
}

